﻿using System;
using System.Runtime.InteropServices;

namespace Synexens
{
    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public struct SYDeviceInfo
    {
        // 设备唯一ID
        public uint m_nDeviceID;

        // 设备类型
        public SYDeviceType m_deviceType;

        public uint m_nUsbBus;

        // 畸变系数
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 7)]
        public uint[] m_nUsbPorts;

        public uint m_nUsbPortsNumber;

        public uint m_nUsbDeviceAddress;
    }

    //事件信息
    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public struct SYEventInfo
    {
        //事件类型
        public SYEventType m_eventType;

        //事件信息数据
        public IntPtr m_pEventInfo;

        //数据长度
        public int m_nLength;
    };

    //数据帧信息
    [StructLayout(LayoutKind.Sequential,Pack = 1)]
    public struct SYFrameInfo
    {
        //帧类型
        public SYFrameType m_frameType;

        //高度（像素）
        public int m_nFrameHeight;

        //宽度（像素）
        public int m_nFrameWidth;
    }

    //数据帧
    [StructLayout(LayoutKind.Sequential,Pack = 1)]
    public struct SYFrameData
    {
        //帧数量
        public int m_nFrameCount;

        //帧信息
        public IntPtr m_pFrameInfo;

        //帧数据
        public IntPtr m_pData;

        //数据长度
        public int m_nBuffferLength;
    };

    //点云数据结构
    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public struct SYPointCloudData
    {
        //X
        public float m_fltX;

        //Y
        public float m_fltY;

        //Z
        public float m_fltZ;
    };
    
    //相机参数结构体
    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public struct SYIntrinsics
    {
        // 镜头视角
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 2)]
        public float[] m_fltFOV;

        // 畸变系数
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 5)]
        public float[] m_fltCoeffs;

        // x 方向的焦距
        public float m_fltFocalDistanceX;

        // y 方向的焦距
        public float m_fltFocalDistanceY;

        // x 方向的成像中心点 即cx
        public float m_fltCenterPointX;

        // y 方向的成像中心点 即cy
        public float m_fltCenterPointY;

        // 宽度
        public int m_nWidth;

        // 高度
        public int m_nHeight;
    }
}